import sys
import getopt
import os


def print_help():
	print('cllm_amazon_parameter_npmi parameters:')
	print('\t-d <datadir>\tdirectory of input data')
	print('\t-s <savedir>\tdirectory of results')
	print('\t-v <float>\tlambda_v default=0.001')
	print('\t-U <float>\tlambda_u2 default=0.5')
	print('\t-B <float>\tlambda_b2 default=0.001')
	print('\t-u <float>\tlambda_u1 default=10')
	print('\t-c <float>\tlambda_c default=10')
	print('\t-b <float>\tlambda_b1 default=0.1')
	print('\t-t <int>\ttopT default=5')
	print('\t-e <float>\teta default=1.0')
	print('\t-k <float>\tR_k in [0.0, 1.0] default=0.5')
	print('\t-S <float>\tR_s in [0.0, 1.0] default=0.6')
	print('\t-T <int>\ttopic number default=50')
	print('\t-D <int>\tword embedding dimension default=1500')
	print('\t-i <int>\titerations default=200')
	print('\t-g\t\tperform grid search default=False')
	print('\t-h\t\tprint help msg')


def parse_argv(argv):
	option = Option()

	try:
		opts, args = getopt.getopt(argv, "d:s:v:U:B:u:c:b:t:e:k:S:T:D:i:gh")
	except getopt.GetoptError:
		print_help()
		sys.exit(2)

	for opt, arg in opts:
		if opt == '-d':
			option.datadir = arg
		elif opt == '-s':
			option.savedir = arg
		elif opt == '-v':
			option.lambda_v = float(arg)
		elif opt == '-U':
			option.lambda_u2 = float(arg)
		elif opt == '-B':
			option.lambda_b2 = float(arg)
		elif opt == '-u':
			option.lambda_u1 = float(arg)
		elif opt == '-c':
			option.lambda_c = float(arg)
		elif opt == '-b':
			option.lambda_b1 = float(arg)
		elif opt == '-t':
			option.topT = int(arg)
		elif opt == '-e':
			option.eta = float(arg)
		elif opt == '-k':
			option.R_k = float(arg)
			if option.R_k < 0 or option.R_k > 1:
				print('parameter error: -k must in [0.0, 1.0]')
				sys.exit(2)
		elif opt == '-S':
			option.R_s = float(arg)
			if option.R_s < 0 or option.R_s > 1:
				print('parameter error: -S must in [0.0, 1.0]')
				sys.exit(2)
		elif opt == '-T':
			option.topic_num = int(arg)
		elif opt == '-D':
			option.emb_size = int(arg)
		elif opt == '-i':
			option.iter_num = int(arg)
		elif opt == '-g':
			option.grid_search = True
		elif opt == '-h':
			print_help()
			sys.exit(0)
		else:
			print_help()
			sys.exit(2)

	return option


class Option:
	def __init__(self):
		self.datadir = os.path.join('data','Ama')
		self.savedir = 'results_cllm_parameter_npmi'

		self.lambda_v = 0.001
		self.lambda_u2 = 0.5
		self.lambda_b2 = 0.001
		self.lambda_u1 = 10
		self.lambda_c = 10
		self.lambda_b1 = 0.1
		self.topT = 5
		self.eta = 1
		self.R_k = 0.5
		self.R_s = 0.6
		self.topic_num = 50
		self.emb_size = 1500
		self.iter_num = 200

		self.grid_search = False

	
